proc()=stockestsim(data)
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       stockest, stocksim
; -----------------------------------------------------------------
;   Macro         stockestsim
; -----------------------------------------------------------------
;   Description   using the given data stockestsim is first 
;		  estimating the parameters 
;                 for the following models:
;                 a Wiener Process (model 1) and 
;                 a Wiener Process with jumps where the jumps are 
;		  following a compounded Poisson Jump Process (model 2)   
;                 and then comparing model 1 and model 2 with 
;                 the real dataset by simulation
; -----------------------------------------------------------------
; Notes 	The trajectory of the Wiener process (diffusion) is the 
;	        black line in the plot. The Wiener process with jumps is
;		the green one and the original data are plotted as a blue line.
; -----------------------------------------------------------------
;   Usage         stockestsim(data)
;   Input         
;     Parameter   data  
;     Definition      n x 1 vector , data of a random process 
;   Output      
; -----------------------------------------------------------------
;   Example   library("finance")
;             data=read("motorola")
;             data=data[,2]
;             stockestsim(data)
; -----------------------------------------------------------------
;   Result     display, showing the real data compared to the simulated
; -----------------------------------------------------------------
;   Author    Hrdle, Kleinow   990511 
; -----------------------------------------------------------------
  n=rows(data)
  // **** estimating parameters of the orignal data
  estvalues = stockest(data)
  // **** rescaling estimated parameter values
  mue    = (1/365)*log((estvalues.mue)/100 +1) 
  mue2   = (1/365)*log((estvalues.mue2)/100 +1) 
  sigma  = (1/sqrt(365))*log((estvalues.sigma)/100 +1) 
  sigma2 = (1/sqrt(365))*log((estvalues.sigma2)/100 +1) 
  jump   = log((estvalues.jump)/100+1)
  dw=normal(n)				// increments of BM
  values = 0.5
  dtv=matrix(n) * values 
  sss=matrix(n)
  ss=matrix(n)
  sss[1]=data[1]
  ss[1]=data[1]
  ds1=mue*dtv+sigma*dw
  ds2=mue2*dtv+sigma2*dw
  i=1
  mit=0.02*mean(data)
  while	(i<n)
    i=i+1
    direct = (2*(uniform(1)<.5)-1)   ; s = -1 <==> decrease, ...
    sprung = (uniform(1) <= ((estvalues.lambda)/n)) * direct * exp(normal(1)) ; jump size
    sprung=jump*sprung
    sss[i]=sss[i-1]*exp(ds1[i-1])
    if (sprung==0)
      ss[i]=ss[i-1]*exp(ds2[i-1])
    else
      ss[i]=ss[i-1]*exp(mue2*values+sprung)
    endif
  endo	
  t = 1:n
  original=t~data
  wiener=t~sss
  sprung=t~ss
  setmaskp(original,0,1,1)
  setmaskp(wiener,0,1,1)
  setmaskp(sprung,0,1,1)
  line=(1:(n-1))~(2:n)
  setmaskl(wiener,line',0,1,1)
  setmaskl(sprung,line',2,1,1)
  setmaskl(original,line',1,1,1)
  d=createdisplay(1,1)
  show(d,1,1,original,wiener,sprung)
  setheadline(d,1,1,"original data, diffusion and diffusion with jumps")
  setgopt(d,1,1,"xlabel", "time")
  setgopt(d,1,1,"ylabel", "stock price")
endp
