proc(at,bt) = sure(a,b)
; -----------------------------------------------------------------------
; Library      wavelet
; -----------------------------------------------------------------------
; See_also     fwt invfwt stein sure2d
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        sure
; -----------------------------------------------------------------------
; Description  Sure denoises wavelet coefficients so that the mean
;              squared error is minimized. MSE is estimated by Stein's
;              unbiased risk estimator based on the variance of the 
;              coefficients. Sure computes the optimal threshold for       
;              the father wavelets and each level of mother wavelets.
;              The input arrays can be obtained by the function 'fwt'.
; -----------------------------------------------------------------------
; Usage        {at, bt} = sure (a, b)
; Input
;   Parameter  a 
;   Definition p x 2 array, indices and coefficients of the father wavelet 
;   Parameter  b 
;   Definition q x 3 array, indices and coefficients of mother wavelet 
; Output
;   Parameter  at
;   Definition p x 2 array, thresholded father wavelet coefficients
;   Parameter  bt
;   Definition q x 3 array, thresholded mother wavelet coefficients   
; -----------------------------------------------------------------------
; Example      ; loads the library wavelet
;              library ("wavelet")
;              n = 128
;               x = grid(0, 1./n, n) 
;              ; computes a noisy step function 
;              y = 0.1*(x.<=0.4) + 2*(abs(x-0.5).<0.1)
;              y = y + 0.5*(abs(x- 0.7)<0.1) 
;              y = y + normal(n)/sqrt(n)
;              ; computes the wavelet coefficients 
;              {a, b} = fwt (y, 2, daubechies2) 
;              ; thresholds the coefficients 
;              {at, bt} = sure (a, b) 
;              ; computes the inverse wavelet transform 
;              ys = invfwt (at, bt, n, 2, daubechies2) 
;              d = createdisplay(1,1)
;              tdat = x~ys
;              setmaskl(tdat, (1:rows(tdat))', 4, 1, 3) 
;              show(d,1,1, tdat, x~y)
; -----------------------------------------------------------------------
; Result       ys denoised estimate of y
; -----------------------------------------------------------------------
; Author       Yurii Golubev, 970921
; -----------------------------------------------------------------------
  c = max (b[,1])
  at = a
  bt = b
  d = paf (b[,3], b[,1] .= c)
  var = mean (d.^2)
  {an, risk} = stein (a[,2], var)
  at[,2] = an 
  i = min (b[,1])
  while (i <= max (b[,1]))
    dat = paf (b[,3], b[,1] .= i)
    it = paf (1:rows(b), b[,1] .= i)
    {datt, risk} = stein (dat, var)
    bt[it,] = b[it, 1:2] ~ datt
    i = i + 1
  endo
endp
