proc (xr,r) = tableN (x)
; ----------------------------------------------------------------------------
; Library       stats
; ----------------------------------------------------------------------------
;  See_also     discrete, table2, mosaic
; ----------------------------------------------------------------------------
;   Macro       tableN
; ----------------------------------------------------------------------------
;   Description  tableN returns a N way table for N-dimensional data.
; ----------------------------------------------------------------------------
;   Keywords    two way table, crosstable, contingency table
; ----------------------------------------------------------------------------
;   Usage        {xr,r} = tableN(x)
;   Input
;     Parameter   x
;     Definition        n x N matrix, the columns correspond to the
;                       variables.
;   Output
;     Parameter   xr
;     Definition        m x N matrix, includes all possible
;                       combinations of values, sorted by last column.
;     Parameter   r
;     Definition        m x 1 vector, contains the number of replications
;                       of each combination. Some values may be 0. 
;                       The sum of r is equal the count of observations.
; ----------------------------------------------------------------------------
;   Example   library("stats")
;             x=(1:4|3)~matrix(5)~(2|2|3|3|3)
;             {xr,r}=tableN(x)
;             xr~r
; ----------------------------------------------------------------------------
;   Result    Contents of _tmp    
;             [1,]        1        1        2        1 
;             [2,]        2        1        2        1 
;             [3,]        3        1        2        0 
;             [4,]        4        1        2        0 
;             [5,]        1        1        3        0 
;             [6,]        2        1        3        0 
;             [7,]        3        1        3        2 
;             [8,]        4        1        3        1 
; ----------------------------------------------------------------------------
;   Author    Swetlana Schmelzer, 970630; Marlene Mueller, 990218
; ----------------------------------------------------------------------------
  N=cols(x)
  n=rows(x)
  one=matrix(N)
  xg=one-1
  hg=one
  ng=one
  ug=matrix(n,N)-1
;
  j=0
  while (j<N)
    j=j+1
    {tmp,tmpr}=discrete(x[,j])
    ng[j]=rows(tmp)
    ug[1:ng[j],j]=tmp
  endo
;
  g=grid(one,one,ng)
  xr=matrix(rows(g),N)
  j=0
  while (j<N)
    j=j+1
    xr[,j]=ug[g[,j],j]
  endo
;
  {xr,r}=discrete(x|xr)
  tmp=sort(xr~r,N:1)
  xr=tmp[,1:N]
  r =tmp[,N+1]-1
endp
