proc(rotm,tourparam)=tourlittle(tourparamin, rm)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        tourlittle
; -----------------------------------------------------------------------
; Description  Computes a little tour rotation matrix.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971112
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.tl>=sum(abs(tourparam.tla)))
    tourparam.tlrot = rm
    p    = rows(rm)
    rotm = sort(uniform(p)~(1:p), 1)
    rotm = (1:p)==rotm[,2]'
    rotm = rotm*inv(rm)
    tourparam.tla = mat2rot(rotm)    
     tourparam.tl = 0
  endif
  tourparam.tl = tourparam.tl+200*tourparam.tldt
  q = min(tourparam.tl/sum(abs(tourparam.tla))|1)
  rotm = rot2mat(q*tourparam.tla)*tourparam.tlrot 
endp
