; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also     tp/cafpe/cafpe, tp/cafpe/cafpefull, tp/cafpe/cafpeload
; -----------------------------------------------------------------
;   Macro       cafpedefault
; -----------------------------------------------------------------
;   Keywords     nonparametric time series analysis, lag selection,
;                Final Prediction Error, CAFPE, local linear regression
; -----------------------------------------------------------------
;   Description Quantlet to define advanced parameters for conducting
;               lag selection for nonlinear autoregressive
;               models using the quantlet cafpefull
; -----------------------------------------------------------------
;   Usage  { xresid,trueres,volat,startval,robden,selcrit,perA,perB,noutputf,outpath }=cafpedefault()
;   Output
;       Parameter   xresid
;       Definition  (nr x 1) vector of residuals for selecting lags
;                   of conditional volatility function; if not needed
;                   set xresid = 0
;       Parameter   trueres
;       Definition  character variable that contains path and name
;                   of residuals stored in ascii file if y=0;
;                   needed if volat = resid
;       Parameter   volat
;       Definition  "no": lag selection for conditional mean function;
;                   "resid": lag selection for conditional volatility function,
;                   the residuals of fitting a conditional mean
;                   function have to be contained in xresid
;       Parameter   startval
;       Definition  character variable, to control treatment of starting values
;                   "different": for each lag vector as few starting
;                                values are used as necessary;
;                   "same": for each lag vector the same starting value is used which
;                           is determined by the largest lag used in the lag selection
;                           quantlet xorigxe
;       Parameter   robden
;       Definition  character variable for switching on/off robustification
;                               of density estimation a la Tjostheim & Auestad (1994),
;                               see also Section 5 in TY
;                               "yes": on; "no": off
;       Parameter   selcrit
;       Definition  character variable to select lag selection critierion:
;                   "lqafpe":  estimating the asymptotic Final Prediction Error (AFPE) using
;                              local linear estimation and a  plug-in bandwidth based on partial
;                              local quadratic estimator
;                   "lqcafpe": estimating the corrected asymptotic Final Prediction Error (CAFPE) using
;                              local linear estimation and a  plug-in bandwidth based on partial
;                              local quadratic estimator
;       Parameter   perA
;       Definition  scalar, parameter used for screening off 0 <= per_A <= 1 percent of the observations
;                   with the lowest density for estimating A, see  eq. (3.1) and Section 5 in TY
;       Parameter   perB
;       Definition  scalar, parameter like per_A but for screening of observations
;                   per_B lowest density for estimating B
;       Parameter   noutputf
;       Definition  character variable, name of output file
;       Parameter   outpath
;       Definition  character variable, path for output file
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc(xresid,trueres,volat,startval,robden,selcrit,perA,perB,noutputf,outpath)=cafpedefault()

    trueres    = "";
    noutputf = "";
    outpath = "";
    selcrit = "lqcafpe";

    ; default settings for advanced parameters - see cafpefull.xpl for explanation
    xresid      = 0;
    robden      = "yes";
    perA       = 0;
    perB       = 0.05;
    startval    = "different";
    volat       = "no";

endp
