; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also		tp/cafpe/cafpe, tp/cafpe/cafpefull, tp/cafpe/cafpedefault
; -----------------------------------------------------------------
;   Macro       cafpeload
; -----------------------------------------------------------------
;   Description Quantlet to load all quantlets including dll/so files
;               which are necessary to run
;               nonparametric lag selection and nonparametric nonlinear
;               autoregression.
;
; -----------------------------------------------------------------
;   Usage  func("<path>\cafpeload.xpl")
;          cafpeload(<path>)
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc () = cafpeload(path)
func(path+"binom.xpl")
func(path+"cafpe.xpl")
func(path+"cafpedefault.xpl")
func(path+"cafpefull.xpl")
func(path+"dencp.xpl")
func(path+"fgrfsv.xpl")
func(path+"fpefsv.xpl")
func(path+"fpenps.xpl")
func(path+"fpenpsl.xpl")
func(path+"fvllc.xpl")
func(path+"hoptest.xpl")
func(path+"hsilv.xpl")
func(path+"lagdir1.xpl")
func(path+"lagfull.xpl")
func(path+"makegrid.xpl")
func(path+"plotloclin.xpl")
func(path+"plotoneline.xpl")
func(path+"wei.xpl")
func(path+"xorigex.xpl")
func(path+"xorigst.xpl")

if (getenv("os") == "windows")
    h = dlopen (path+"locling.dll")
    h = dlopen (path+"density.dll")
else
    h = dlopen (path + "locling.so")
    h = dlopen(path + "den_c.so")
endif
endp
