; -----------------------------------------------------------------
; Library        cafpe 
; -----------------------------------------------------------------
;  See_also     tp/cafpe/fvllc
; -----------------------------------------------------------------
;   Macro       dencp
; -----------------------------------------------------------------
;   Keywords    multivariate density estimation, nonparametric estimation,
;               kernel estimation
; -----------------------------------------------------------------
;   Description Quantlet for multivariate density estimation using
;               kernel estimation using C++ routines via a DLL.
;
; -----------------------------------------------------------------
;   Usage   dh = dencp(x,h,xest,loo,kernden)
;   Input
;	 Parameter         ATTENTION:
;      Definition  this quantlet requires to open locling.dll, density.dll (NT)
;               or locling.so, denc.so (UNIX). This can be done with the quantlet cafpeload or 
;               directly with
;               garb = dlopen ("<path>\density.dll") on NT,
;               garb = dlopen ("<path>/denc.so") on UNIX.
;       Parameter   x
;       Definition  (n x d) matrix of observations
;       Parameter   h
;       Definition  (d x 1) vector of bandwidths
;       Parameter   xest
;       Definition  (nest x d) matrix of points at which the density has to be computed
;       Parameter   loo
;       Definition  scalar, parameter to control leave-one-out:
;                   0 = no leave-one-out, 1 = leave-one-out
;       Parameter   kernden
;       Definition  character variable for selecting kernel function:
;                   "gaussian": Gaussian kernel
;   Output
;       Parameter   dh
;       Definition  (nxest x 1) estimated density at xest
; -----------------------------------------------------------------
;   Example    pathcafpe = "tp/cafpe/"
;		   library("xplore")
;		   func(pathcafpe + "cafpeload.xpl")
;              cafpeload(pathcafpe)
;			n               = 100
;    			x               = normal(n,1)
;    			loo     = 0
;    			kerntype = "gaussian"
;    			h               = hsilv(sqrt(var(x)),1,n,kerntype)
;    			xs		= sort(x)
;    			dh      = dencp(x,h,xs,loo,kerntype)
;    			plotoneline(xs~dh, "density estimate", " ", " ")
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc (dh) = dencp(x,h,xest,loo,kernden);

;/* checks */
error(cols(x) != cols(xest), "quantlet  dencp: x and xest do not have the same number of regressors");
error(!((loo==0) || (loo==1)), "quantlet  dencp: loo must be 0 or 1.")
error(prod(h .<= 0), "quantlet dencp: bandwidth must be positive.")
error((rows(h)>1) && (rows(h) != cols(x)), "quantlet dencp: bandwidth vector not of the same dimension than number of regressors.")
if (cols(h) > 1);
    h   = h';
    "quantlet dencp: Warning: bandwidth vector was transposed";
endif;
if ((rows(h)== 1) && (cols(h) == 1) && cols(xest) != 1)
    "quantlet dencp: scalar bandwidth used";
    h   = h * matrix(cols(x),1);
endif;

xc      = x';
nc      = rows(x);
pc      = cols(x);
hc      = h;
xtj   = xest';
xtjro= rows(xest);
dh      = zeros(xtjro,1);
looc    = loo;

if (kernden == "gaussian");
    tempp=dlcall ("den_c",xc, nc, pc, hc, xtj, xtjro, dh, looc);
else;
    error(kernden != "gaussian", "quantlet dencp: density estimation only programmed for gaussian kernel.");

endif;

endp;

;/* =============================================================== */
