; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also     tp/cafpe/fpefsv
; -----------------------------------------------------------------
;   Macro       fgrfsv
; -----------------------------------------------------------------
;   Keywords    nonparametric autoregression, local linear estimation
; -----------------------------------------------------------------
;   Description Quantlet to compute local linear estimator of conditional
;               mean function
;
; -----------------------------------------------------------------
;   Usage   { ghat,denA,err } = fgrfsv(Xsj,Yorig,hA,Xtj,kernel,estimator)
;   Input
;	 Parameter         ATTENTION:
;      Definition  this quantlet requires to open locling.dll, density.dll (NT)
;               or locling.so, denc.so (UNIX). This can be done with the quantlet cafpeload or 
;               directly with
;               garb = dlopen ("<path>\locling.dll") on NT,
;               garb = dlopen ("<path>/locling.so") on UNIX.

;       Parameter   xsj
;       Definition  (ny x d) matrix with explanatory variables for all dependenet observations
;       Parameter   yorig
;       Definition  (ny x 1) vector with dependent variable
;       Parameter   hA
;       Definition  scalar, estimate of asymptotically optimal bandwidth
;       Parameter   xtj
;       Definition  (nx x d) matrix with values at which function has  to be estimated
;       Parameter   kernel
;       Definition  character variable to select kind of kernel: "gaussian": Gaussian kernel
;       Parameter   estimator
;       Definition  character variable for selection nonparametric estimator
;                   "loclin": local linear estimator; other estimators not
;                   implemented
;   Output
;       Parameter  ghat
;       Definition (nx x 1) matrix of conditional mean
;       Parameter  denA
;       Definition (nx x 1) vector of density
;       Parameter  err
;       Definition 0 if matrix inversion in dll ok, 1 if matrix inversion failed

; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------


proc (ghat,denA,err) = fgrfsv(Xsj,Yorig,hA,Xtj,kernel,estimator);

; -------------------- initialize -------------------------------

    sigK           = 1;
    dw             = cols(Xtj);

; ----------------- estimate mean functions  --------------------

    loo     = 0;    /* no leave-one out */
    fandg   = 0;    /* only cond. mean  */

    switch
    case (estimator == "loclin");
        lorq    = 1;    /* local linear     */
        break
    endsw


    { mA,gsqA,denA,err } = fvllc(Xsj,Yorig,hA,Xtj,kernel,lorq,fandg,loo);

    ghat       = mA[,1];
    if (err == 1);
        warning(err,"quantlet fgrfsv: function estimation has missing values at given hA")
        hA;
    endif

endp
