; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also     tp/cafpe/lagfull
; -----------------------------------------------------------------
;   Macro        lagdir1
; -----------------------------------------------------------------
;   Keywords    time series analysis, lag selection
; -----------------------------------------------------------------
;   Description Quantlet for conducting directed search as in
;               Tjostheim and Auestad (1994) for lag selection.
;               It collects all lags which have not yet been
;               selected into a vector lagno
; -----------------------------------------------------------------
;   Usage   { lagno,lagnor } = lagdir1(lagmax,dc,lagdc1)
;   Input
;     Parameter  lagmax
;     Definition scalar, largest lag to be considered for input
;                variable selection
;     Parameter  dc
;     Definition scalar, number of variables to be included
;                in lag vector lagno
;     Parameter  lagdc1
;     Definition vector that contains all input variables
;                which already have been selected
;   Output
;     Parameter  lagnor
;     Definition scalar, number of input variables that are included in lagno
;     Parameter  lagno
;     Definition (lagnor x 1) vector that contains all input variables
;                that have to be checked in the next round
; -----------------------------------------------------------------
;   Example     pathcafpe 	= "tp/cafpe/"; path of CAFPE quantlets
;		func(pathcafpe + "lagdir1.xpl")
;		lagmax  	= 6
;               dc      	= 4
;               lagdc1  	= 1|3
;               { lagno,lagnor }= lagdir1(lagmax,dc,lagdc1)
;               "lagno" lagno
;               "lagnor" lagnor
; -----------------------------------------------------------------
;   Result    returns vector of lags to be possibly added next and
;             and their number
; -----------------------------------------------------------------
;  Reference    Tjostheim, D. and Auestad, B. (1994) Nonparametric
;               identification of nonlinear time series:
;               selecting significant lags.
;               Journal of the American Statistical Association 89, 1410-1419.
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc (lagno,lagnor) = lagdir1(lagmax,dc,lagdc1);

    dexog  = 0   			; number of exogeneous variables 
    lagno  = zeros(lagmax+dexog,1)	; Init. vector that stores 
					; all lags which have
                                        ; to be tested for one given dc
					; example: d=2,k=3 and lag 1 has 
					; already been chosen, lagno = 2|3

    lagsso = sort(lagdc1,1)		; vector that includes all lags already
					; selected for smaller dc; sorted    
    lagcc  = 1;
    kk      = 1;
    do

        if  (lagcc == lagsso[kk])	; lag has already been selected; go on 

            if (kk < rows(lagsso));
                kk      = kk + 1;
            endif;

       else;

            lagno[lagcc] = lagcc	; try lag 


       endif;
       lagcc   = lagcc + 1;
    until (lagcc > lagmax + dexog);     

    lagno      = paf(lagno,lagno .> 0);
					; due to init. possibly more
					; rows in lagno than sel.
					; lags; delete those    
    lagnor    = rows(lagno)		; number of lags to be tested

endp;

