; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also     tp/cafpe/lagdir1
; -----------------------------------------------------------------
;   Macro        lagfull
; -----------------------------------------------------------------
;   Keywords    time series analysis, lag selection
; -----------------------------------------------------------------
;   Description Quantlet to generate matrix of all possible combinations of
;               lags in order to conduct a full search for lag selection.
; -----------------------------------------------------------------
;   Usage   {lagcomball,lagcomb} =  lagfull(lagnor,dmax)
;   Input
;     Parameter   lagnor
;     Definition  scalar, total number of input variables
;     Parameter   dmax
;     Definition scalar, max number of input variables to be allowed
;   Output
;     Parameter   lagcomball
;     Definition  (dmax x sumc(lagcomb)) matrix that contains
;                 all valid input variable combinations
;     Parameter   lagcomb
;     Definition  vector, gives number of possible input variable
;                 combinations for an increasing sequence of
;                 the number of lags

; -----------------------------------------------------------------
;   Example     pathcafpe = "tp/cafpe/"
;               func(pathcafpe + "lagfull.xpl")
;               lagnor  = 4
;               dmax    = 3
;               {lagcomball,lagcomb} =  lagfull(lagnor,dmax)
;               "lagcomb" lagcomb
;               "labcomball' " lagcomball'
; -----------------------------------------------------------------
;   Result    returns al possible lag combinations and the number
;             of combinations for each given number of lags
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc (lagcomball,lagcomb) =  lagfull(lagnor,dmax)


    lagcomb    = zeros(dmax,1);   /* vector that contains number of all possible combinations of lags for a given number of lags */
    dc         = 1;
    do
        lagcomb[dc]   = binom(lagnor,dc);
        dc             = dc + 1;
    until (dc > dmax)

   lagcombtot = sum(lagcomb);   /* total number of combinations */
   lagcomball = zeros(dmax,lagcombtot);
                        /* init. matrix to store
                         all combinations */


   lagcomball[1,1:lagnor] = (#(1:lagnor))'; /* do lags for dc = 1 */
   lagcomballc  = lagnor+1;

   dc      = 2;
   do

    lagcombc = 1;
    do
                                    /* get vector of lags of dc-1
                                       to add all possible lags
                                       later */

        if (dc > 2);
            garb = sum(lagcomb[1:dc-2]);
        else;
            garb = 0;
        endif;

        lagsal = lagcomball[1:dc-1,garb+lagcombc];
        lagmin = max(lagsal);
        lc = lagmin+1;
        if (lc <= lagnor)
            do
              lagcomball[1:dc,lagcomballc] = lagsal|lc;
              lagcomballc = lagcomballc + 1;
              lc     = lc + 1;
           until (lc > lagnor);
                endif
      lagcombc = lagcombc + 1;
     until (lagcombc > lagcomb[dc-1]);

     dc     = dc + 1;
   until (dc > dmax)


endp;
