; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also		plot
; -----------------------------------------------------------------
;   Macro       plotoneline
; -----------------------------------------------------------------
;   Keywords    plotting
; -----------------------------------------------------------------
;   Description Quantlet to produce a graph of a matrix
; -----------------------------------------------------------------
;   Usage   plotoneline(x1,title,xlabel,ylabel)
;   Input
;     Parameter  x1
;     Definition n x 2 matrix of data
;     Parameter  title
;     Definition character, title for graph
;     Parameter  xlabel
;     Definition character, label for x-axis
;     Parameter  ylabel
;     Definition character, label for y-axis
; -----------------------------------------------------------------
;   Example     pathcafpe 	= "tp/cafpe/" 	; path of CAFPE quantlets
;		    func(pathcafpe + "plotoneline.xpl")	; load required XploRe files of CAFPE
;               d       	= 1
;               ntotal  	= 100
;               y       	= normal(ntotal,d)
;		    plotoneline(1:ntotal~y,"testgraph","x-axis","y-axis")
; -----------------------------------------------------------------
;   Result    plots 100 observations of normal random variables
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc() = plotoneline(x1,title,xlabel,ylabel)
   d=createdisplay(1,1)
   setmaskl (x1, (1:rows(x1))', 0, 1) 
   show(d,1,1,x1)
   setgopt(d, 1, 1,"title",title,"xlabel",xlabel,"ylabel",ylabel)
endp