; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also
; -----------------------------------------------------------------
;   Macro        wei
; -----------------------------------------------------------------
;   Keywords    nonparametric time series analysis, weight function
; -----------------------------------------------------------------
;   Description Quantlet for weighting the observations.
;               It returns either a 1 or 0 for each observation
;               according to whether it should be kept or ignored.
;               This is decided on whether the density of the vector 
;		of lags is larger than a certain threshold. The threshold is computed
;               such that per*#obs observations are thrown away
;               which are those with the lowest density.
;               If a density matrix is handed over, the operation is
;               done on column i.
; 
; -----------------------------------------------------------------
;   Usage   w = wei(den,per,i)
;   Input
;     Parameter   den
;     Definition  (nn x d) matrix of estimated density
;     Parameter   per
;     Definition  scalar, 0<=per<=1, fraction to be cut off
;     Parameter   i
;     Definition  scalar, column in den used for evaluation
;   Output
;     Parameter   w
;     Definition  (nn x 1) matrix of zeros and ones
; ----------------------------------------------------------------
;  Reference    Tjostheim, D. and Auestad, B. (1994) Nonparametric
;               identification of nonlinear time series:
;               selecting significant lags.
;               Journal of the American Statistical Association 89, 1410-1419.
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc (w) = wei(den,per,i);

if (per > 0);
    n       = rows(den);
    co      = cols(den);
    dens   = den;

    dens   = sort(dens,i);
    w       = ( den[,i] .> dens[ceil( per * rows(den) ),i] * matrix( n,1 ) );
else;
    w       = matrix(rows(den),1);
endif;
endp;

;/* ======================================================================== */
