; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also      tp/cafpe/xorigst
; -----------------------------------------------------------------
;   Macro        xorigex
; -----------------------------------------------------------------
;   Keywords    time series analysis
; -----------------------------------------------------------------
;   Description  Quantlet to construct matrix of lagged variables
; -----------------------------------------------------------------
;   Usage          { xorigau,yorig }= xorigex(xraw,xresid,lags,volat)
;   Input
;       Parameter   xraw
;       Definition n x 1 matrix, the observed time series
;       Parameter   xresid
;       Definition  (nr x 1) vector of residuals for selecting lags
;                   of conditional volatility function; if not needed
;                   set xresid = 0
;       Parameter   lags
;       Definition  (d x 1) vector of lags to be considered
;       Parameter   volat
;       Definition  "no": lag selection for conditional mean function;
;                   "resid": lag selection for conditional volatility function,
;                   the residuals of fitting a conditional mean
;                   function have to be contained in xresid
;   Output
;     Parameter   xorigau
;     Definition  ((t-max(lags)+min(lags)) x d) matrix of regression values
;     Parameter   yorig
;     Definition  ((t-max(lags)) x 1) matrix  of dependent variable
; -----------------------------------------------------------------
;   Example     pathcafpe = "tp/cafpe/"
;	    	    func(pathcafpe + "xorigex.xpl")
;   		    xraw = #(1:100)
;               lags = 1|10
;               { xorigau,yorig }= xorigex(xraw,0,lags,"no")
;               "xorigau" xorigau
;               "yorig" yorig
; -----------------------------------------------------------------
;   Result    The matrix of dependent and independent variables
;             Note that for regressing yorig on xorigau you have to
;             use the submatrix
;                   xorig = xorigau[1:rows(yorig),]
;             since xorigau contains all possible observations for density
;             estimation
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc (xorigau,yorig)= xorigex(xraw,xresid,lags,volat);

; adjust xraw for volat $== "resid" if necessary

    if ((volat == "resid") && (rows(xresid) != rows(xraw)));
            /*
            "first xraw - xresid rows cut off of xraw and xexog.";
            "this is done since xresid has less rows";
            "due to the estimation of f";
            */
        xraw        = xraw[rows(xraw)-rows(xresid)+1:rows(xraw),];
    endif;


    t           = rows(xraw);
    lags        = sort(lags,1);
    lagrows     = rows(lags);

;  determine smallest lag and largest lag to be constructed from xraw

    lagmin      = lags[1];
    lagmax  = lags[lagrows];

    xorigau    = zeros(t-lagmax+lagmin,lagrows);

    i   = 1;
    do
        clag    = 1;
        do

            xorigau[i,clag]  = xraw[i+lagmax-lags[clag]];
            clag           = clag + 1;
        until (clag > lagrows);
        i        = i + 1;
    until ( i > t-lagmax+lagmin);

    switch
    case (volat == "no")
        yorig       = xraw[lagmax+1:t];
	break
    case (volat == "resid")
        yorig = (xresid[lagmax+1:t])
	break
    default
        warning(1,"quantlet xorigex: volat neither chosen to be no or resid");
	break
    endsw

endp
