proc(y)=transform(x, prep)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     groupcol
; -----------------------------------------------------------------------
; Macro        transform
; -----------------------------------------------------------------------
; Description  Transforms the given dataset.
; -----------------------------------------------------------------------
; Usage        y = transform (x, prep)
; Input
;   Parameter  x
;   Definition n x p matrix
;   Parameter  prep
;   Definition scalar
; Output
;   Parameter  y
;   Definition n x p matrix
; -----------------------------------------------------------------------
; Notes        prep allows some transformation of the data:
;              grc.prep.none       0     no transformation
;              grc.prep.standard   1     standardize
;              grc.prep.zeroone    2     to [0,1]
;              grc.prep.pcacov     3     pca on cov matrix
;              grc.prep.pcacorr    4     pca on corr matrix
;              grc.prep.sphere     5     sphering
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; generates a matrix (100x5) with uniform random numbers
;              x = uniform(100, 5)
;              ; computes the principal components of x
;              y = transform(x, grc.prep.pcacov)
;              y 
; -----------------------------------------------------------------------
; Result       returns the principal components of x based on the 
;              covariance matrix
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970201
; -----------------------------------------------------------------------
  grc = getglobal ("grc") 
  y = x
  if (prep==grc.prep.inter)
    selhead = "Data preparation"
    selitem = "Standardize"|"[0,1]"|"PCA on Cov"|"PCA on Corr"|"Sphere"
    do
      sel = selectitem(selhead, selitem)
    until (sum(sel).<2)    
    sel = sum(cumsum(sel))
    if (sel)
      sel = grc.prep.sphere+1-sel
    endif
    prep = sel
  endif
  switch 
  case (prep==grc.prep.standard)
    y = (y-mean(y))./sqrt(var(y))
    break
  case (prep==grc.prep.zeroone)
    y = (y-min(y)) ./ (max(y)-min(y))
    break
  case (prep==grc.prep.pcacov)
    y = y-mean(y)
    c = cov(y)
    {e, v} = eigsm(c)
    ev = sort(e~v', -1)
    y = y*trans(ev[,2:cols(ev)])
    break
  case (prep==grc.prep.pcacorr)
    y = y-mean(y)
    c = corr(y)
    {e, v} = eigsm(c)
    ev = sort(e~v', -1)
    y = y*trans(ev[,2:cols(ev)])
    break
  case (prep==grc.prep.sphere)
    y = y-mean(y)
    {u, l, v} = svd(cov(y))
    s = u./sqrt(l')
    y = y*s
    break
  endsw
endp