proc() =twboxcoxloop(x)
; -----------------------------------------------------------------------
; Library      tware 
; -----------------------------------------------------------------
; See_also     twboxcox hinesplot boxcox boxcoxdens
; -----------------------------------------------------------------------
; Macro        twboxcoxloop
; -----------------------------------------------------------------------
; Description  main loop  for twboxcox
; -----------------------------------------------------------------------
; Author       Susanne Hannappel, 970220 
;              Sigbert Klinke, 970820
; ----------------------------------------------------------------------
  q = #(0.1,0.15, 0.2,0.25, 0.33)
  setsize (1100,500)
  hines = createdisplay(1,2)
  out = twboxcoxintroduction()
  show (hines,1,1,out)
  p = 0.1
  p = readvalue("Which p do you want to try?",p)
  hinesplot (x,p,q,hines,"new")
  headline = ("Do you want to try a better p?") 
  items = "yes" | "no" 
  i = selectitem(headline, items, "single")
  while (sum(i==#(1,0)>0))
    if (sum(i==#(1,0))==1)
      headline = ("Choose exactly one option! Do you want to try a better p?") 
      items    = "yes" | "no" 
      i = selectitem(headline, items, "single") 
    endif  
    if (sum(i==#(1,0))==2)   
      p = readvalue("Which p do you want to try?",p)    
      hinesplot (x,p,q,hines,"add")
      headline = ("Do you want to try a better p?") 
      items = "yes" | "no" 
      i = selectitem(headline, items, "single")
    endif    
  endo
 
  p = readvalue("Which p will choose for your Box-Cox Transformation ?",p)
  boxcoxdens(x,p)
endp 
