proc()=twrandomsample(nin)
; -----------------------------------------------------------------------
; Library      tware
; -----------------------------------------------------------------------
; See_also     twpvalue twnormalize twclt twpearson tw1d twlinreg
; -----------------------------------------------------------------------
; Macro        twrandomsample
; -----------------------------------------------------------------------
; Description  teachware quantlet twrandomsample asks for a distribution 
;							 of the numbers {1, 2, 3, 4}
; 						 displays a bar chart of the entered
;							 values and calculates a test for H0: p{2,3} = 0.5, the 
;							 hypothesis of uniform distribution.
;------------------------------------------------------------------------
; Usage        twrandomsample({nin})   
; Input
;   Parameter  nin
;   Definition vector (4x1)
; -----------------------------------------------------------------------
; Example    ; load teachware library
;            library("tware")
;            ; predefine some counts for the numbers 1,2,3,4
;            nin=2|10|5|3
;            ; call random sample teachware example
;            twrandomsample(nin)
; -----------------------------------------------------------------------
; Result     a graphic with bar chart representing the observed counts 
;						 and a text window with p-values and test statistic for 
;						 the hypothesis H0: p{2,3} = 0.5	
; -----------------------------------------------------------------------
; Keywords   teachware
;------------------------------------------------------------------------
; Author     SK, WH, 981231
;------------------------------------------------------------------------
  if (exist(nin)<>1)				// check for optional input 
    nin = 2|15|12|3
  endif
  s=string("%g", 1:rows(nin))|"Alpha"
  na=readvalue(s, nin|0.05)
  alpha=na[rows(na)]				// user defined significance level
  nin=na[1:rows(na)-1]				// user given freq's
  if ((sum(nin<0)==0) && (sum(nin==0)<rows(nin)))
    twdex1 = createdisplay(2,1)
    i = 1:4
    col = 0								// draw black boxes
    grbin = (i-1/3)|(i-1/3)|(i+1/3)|(i+1/3)	// generate bars
    grbin = grbin~((0*i)|nin|nin|(0*i))		
    n   = 4
    lt1 = (i~(n+i)~(2*n+i)~(3*n+i)~i)	
    setmaskp(grbin, 0, 0, 0)			// get rid of point structure
    setmaskl(grbin, lt1, col, 1, 0)		// define which pts to connect
    show(twdex1, 1, 1, grbin)
// *********************************************** calc test stat
    n   = sum(nin)
    p   = (nin[2] + nin[3])/n
    pd  = qfn(1-alpha/2)*sqrt(0.25/n)  
    txt = string("phat=P({2,3})=%.3f          (n=%g)", p, n)
    txt = txt|""|string ("H0: p=0.5 H1: p<>0.5   alpha=%.3f", alpha)|""
    txt = txt|string("H0 = {%.3f<p<%.3f}   (if n>30)", 0.5-pd, 0.5+pd)
    show(twdex1,2,1,txt) 
  endif
endp















