
proc (y) = uni(x)

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     cosi epa gau qua tri trian 
; -----------------------------------------------------------------
;   Macro       uni
; -----------------------------------------------------------------
;   Description  uni computes the uniform kernel, multivariate
; -----------------------------------------------------------------
;   Usage        y = uni(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-2, 41, 0.1) 
;             y = uni(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Isabel Proenca & Lijian Yang, 951117   
; -----------------------------------------------------------------


  y = prod(0.5 .*(abs(x).<1),2) 

endp 

