proc(y, z, r, c)=wardcont(x, k, l) 
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    kmcont adaptive distance agglom kmeans 
; -----------------------------------------------------------------------
; Macro       wardcont
; -----------------------------------------------------------------------
; Description performes Ward's hierarchical cluster analysis
;             of the rows as well as of the columns of a
;             contingency table including the multivariate
;             graphic using the correspondence analysis;
;             makes available the factorial coordinates
;             of the row points and column points (scores)
; -----------------------------------------------------------------------
; Usage       cw = wardcont (x, k, l) 
; Input
;   Parameter  x
;   Definition n x p  matrix of n row points to be clustered (the
;                     elements must be >= 0, with positive marginal
;                     sums) 
;   Parameter  k
;   Definition scalar the maximum number of clusters of rows
;   Parameter  l
;   Definition scalar the maximum number of clusters of columns  
; Output
;   Parameter  cw.y
;   Definition n x l  matrix correspondence analysis scores of the
;                     row points (l = min(n-1,p-1)
;   Parameter  cw.z
;   Definition p x l  matrix: correspondence analysis scores of the
;                     column points  
;   Parameter  cw.r
;   Definition n x 1  matrix: Partition of n points into k clusters
;   Parameter  cw.c
;   Definition p x 1  matrix: Partition of p points into l clusters
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate a data set
;             x = #(4, 4, 25, 18, 10)~#(2, 3, 10, 24, 6)~#(3, 7, 12, 33, 7)~#(2, 4, 4, 13, 2)
;             ; apply the ward method
;             cw = wardcont(x, 3, 4)
; -----------------------------------------------------------------------
; Result      produces three displays with the ward analysis for the rows,
;             for the columns and for both.
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
   n = sum(sum(x,2))                         ; total sum 
   nr = sum(x,2)                            ; marginal sum (rows) 
   nc = sum(x)'                             ; marginal sum (columns) 
   ok = (min(nr)>0) && (min(nc)>0) 
   if(ok) 
      a = n./nc                             ; column weigths 
      m = nr./n                             ; row masses 
      u = x./nr                             ; row profiles
      q = u.*trans(sqrt(a))                   ; weigthed row profiles 
;             clustering the rows 
      d = distance(u, "euclid", a) 
      d = mat2vec(d)
      d = d.*d 
      aggward = agglom(d, "WARD", k, m) //, m)
      r = aggward.p
      t = aggward.t
      s = aggward.g
;;      ss=string("%.0f", s[,2]) 
;;      s=s~ss 
      ss=tree(s, 0.0, "CENTER"|"XAXIS") 
      ss=ss.points
      ss[,2]=max(ss[,2])-ss[,2] 
      ps = 5.*(1:rows(ss)/5)+(0:3)'-4
      setmaskl(ss, ps, 0, 1, 2)
      setmaskp(ss, 0, 0, 0)
      wardrows = createdisplay(2,2) 
      show(wardrows, 1, 1, ss) 
      setgopt (wardrows, 1, 1, "title", "allrows") 
;;      ts=string("%.0f" t[,2]) 
;;      t=t~ts 
      tt=tree(t, 0.0, "CENTER"|"XAXIS")
      tt=tt.points
      tt[,2]=max(tt[,2])-tt[,2] 
      ps = 5.*(1:rows(tt)/5)+(0:3)'-4
      setmaskl(tt, ps, 0, 1, 2)
      setmaskp(tt, 0, 0, 0)
;;      clusrows = createdisplay(1,1) 
      show(wardrows, 2, 1, tt) 
      setgopt (wardrows, 2, 1, "title", "clusrows") 
;             multivariate graphics 
      w = x./sqrt(nr) 
      u = w./trans(sqrt(nc)) 
      g=trans(u)*u 
      {e, bev}=eigsm(g) 
      g=e~trans(bev) 
      g=sort(g, (-1)) 
      g=g[2:rows(g),] 
      ll=trans(sqrt(g[,1])) 
      z=trans(g[,2:cols(g)]) 
      y=q*z 
;;      wardrows = createdisplay(1,1)
      j=y[,1:2]
      setmaskp (j, r)
      jjj=y[,1:3]
      setmaskp(jjj, r)
      show(wardrows, 1, 2, j) 
      setgopt (wardrows, 2, 1, "title", "wardrows") 
      qualaxes = "Quality of axes:"|string("%10.5f %10.5f", g[,1], g[,1].*100./sum(g[,1])) 
      show (wardrows, 2, 2, qualaxes)
;             clustering the columns 
      x = trans(x) 
      a = n./nr                             ; row weigths 
      m = nc./n                             ; column masses 
      u = x./nc                             ; column profiles 
      q = u.*trans(sqrt(a))                   ; weigthed row profiles 
      d = distance(u, "EUCLID", a) 
      d = d.*d 
      aggward = agglom(d, "WARD", l, m)
      c = aggward.p
      t = aggward.t
      s = aggward.g
;;      ss=string("%.0f" s[,2])
;;      s=s~ss
      ss=tree(s, 0.0, "CENTER")
      ss=ss.points
      ss[,2]=max(ss[,2])-ss[,2]
      ps = 5.*(1:rows(ss)/5)+(0:3)'-4
      setmaskp(ss, 0, 0, 0)
      setmaskl(ss, ps, 0, 1, 2)
      wardcols = createdisplay(2,2)
      show(wardcols, 1, 1, ss)
      setgopt (wardcols, 1, 1, "title", "allcols")
;;      ts=string("%.0f" t[,2])
;;      t=t~ts
      tt=tree(t, 0.0, "CENTER")
      tt=tt.points
      tt[,2]=max(tt[,2])-tt[,2]
      ps = 5.*(1:rows(tt)/5)+(0:3)'-4
      setmaskl (tt, ps, 0, 1, 2)
      setmaskp (tt, 0, 0, 0)
;;      cluscols = createdisplay(1,1)
      show(wardcols, 2, 1, tt)
      setgopt (wardcols, 2, 1, "title", "cluscols")
      z=(u*y)./ll
;;      wardcols = createdisplay(1,1)
      p=z[,1:2]
      setmaskp (p, c)
      show(wardcols, 1, 2, p)
      setgopt (wardcols, 1, 2, "title", "wardcols")
;;      wardboth = createdisplay(1,1)
      wardboth = createdisplay(2,1)
      show(wardboth, 1, 1, j, p)
      setgopt (wardboth, 1, 1, "title", "wardboth 2D")
      p=z[,1:3]
      setmaskp (p, c)
;;      wardboth3d = createdisplay(1,1)
      show(wardboth, 2, 1, jjj, p)
      setgopt (wardboth, 2, 1, "title", "wardboth 3D")
   endif
endp
