; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      eivvec2
; ----------------------------------------------------------------------------
; Macro         eiv07
; ----------------------------------------------------------------------------
; Description   estimates the vector of parameters of eiv model for simulated
;		data using eivvec2
; ----------------------------------------------------------------------------
library("xplore")
library("eiv")
n=100
randomize(n)
sig=0*matrix(3,3)
sig[,1]=#(0.25, 0.09, 0.1)
sig[,2]=#(0.09, 1, 0.2)
sig[,3]=#(0.1, 0.2, 0.4)
x=sort(uniform(n,3)*sig)
w=x+0.03*normal(n,3)
beta0=#(0.5, 0.6, 0.7)
y=x*beta0+0.05*normal(n)
gamma=(#(0.03,0,0,0))'|(#(0,0,0)~0.05*unit(3))
gest=eivvec2(w,y,gamma)
gest.hatbeta
gest.sigmam
