; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         flts05 
; ----------------------------------------------------------------------------
; Description   Diagnostics for local linear estimates of NAR(1) model
;               for lynx data
; ----------------------------------------------------------------------------
  library("smoother")
  library("plot")
  library("times")
  func("jarber")
  setsize(640,480)
;	data preparation	
  lynx		= read("lynx.dat")
  lynxrows 	= rows(lynx)				
  lag1		= lynx[1:lynxrows-1]  		; vector of first lag
  y   		= lynx[2:lynxrows]    		; vector of dep. var.
  data 		= lag1~y	
  data		= log(data)	   		
  datain	= data~#(1:lynxrows-1)		; add index to data
  dataso	= sort(datain,1)		; sorted data
;	estimation
  h		= 1.12085			; Cross-validation bandwidth
  mhlp		= regxest(dataso[,1|2],h)	; local constant estimation
; 	graphics
  mhlp		=setmask(mhlp,"line","red")				
  xy		=setmask(data,"cross","small")
  plot(xy,mhlp)
  setgopt(plotdisplay,1,1,"title","Estimated NAR(1) mean function","xlabel","First Lag","ylabel","Lynx")
;						diagnostics
  yhatso	= mhlp.data[,2]~dataso[,3] 	; sorted estimated function values
  yhat		= sort(yhatso,2)		; undo sorting
  eps		= data[,2] - yhat[,1]		; compute residuals
  acfplot(eps)					; plot autocorrelation function of residuals
  setgopt(dacf,1,1,"title","Autocorrelation function of NAR(1) residuals")
;
  {jb,probjb,sk,k} = jarber(eps,1)		; compute Jarque-Bera test for normality of residuals






