; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      gplmopt gplmest gplmout 
; ----------------------------------------------------------------------------
; Macro         gplm03
; ----------------------------------------------------------------------------
; Description   GPLM estimation for the Credit data using
;               profile likelihood.
; ----------------------------------------------------------------------------
  library ("plot")

  file=read("kredit")  
  file=paf(file,(file[,5]>=1)&&(file[,5]<=3)) 
                                     ; purpose=car/furniture
  y=file[,1]
  x=(file[,4]>2)                     ; previous loans o.k.
  x=x~(file[,8]>2)                   ; employed (>=1 year)
  x=x~(file[,3])                     ; duration of loan
  t=(file[,6])                       ; amount of loan
  t=t~(file[,14])                    ; age of client
  xvars="previous"|"employed"|"duration"
  tvars="amount"|"age"
;
  t=log(t)               ; logs of amount and age
  trange=max(t)-min(t)
  t=(t-min(t))./trange   ; transformation to [0,1]
;
  scatter=createdisplay(1,1)
  t=setmask(t,"cross")
  show(scatter,1,1,t)
  xl="amount"
  yl="age"
  tl="Amount vs. Age"
  setgopt(scatter,1,1,"xlabel",xl,"ylabel",yl,"title",tl)
;
  library("gplm")
;
  h=0.4
  opt=gplmopt("meth",1,"shf",1)
  opt=gplmopt("xvars",xvars,opt)
  opt=gplmopt("tg",grid(0|0,0.05|0.05,21|21),opt)
  g=gplmest("bilo",x,t,y,h,opt)
  gplmout("bilo",x,t,y,h,g.b,g.bv,g.m,g.stat,opt)
;
  library("plot")
  mg=setmask(sort(opt.tg~g.mg,1:2),"surface")
  box=grcube(mg)
  function=createdisplay(1,1)
  axesoff()
  show(function,1,1,mg,box.box,box.x,box.y,box.z)
  axeson()
  xl="amount"
  yl="age"
  tl="Amount & Age -> Credit"
  setgopt(function,1,1,"xlabel",xl,"ylabel",yl,"title",tl)
;
  a=(0.92388~0.14644~-0.35355)|(-0.38268~0.35357~-0.85355)|(0~0.92388~0.38269)
  setgopt(function,1,1,"rotcos",a)



