; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      hazbeta hazregll
; ----------------------------------------------------------------------------
; Macro         haz06
; ----------------------------------------------------------------------------
; Description   estimates the parameters of Cox model for simulated data
; ----------------------------------------------------------------------------
 library("hazreg")
 dat=read("haz01.dat")  
 t = dat[,1]                        ; observed times                      
 delta = dat[,2]                    ; censoring indicator                       
 z = dat[,3:4]                      ; covariates                    
 {data,ties} = hazdat(t,delta, z)   ; preparing data
 {betahat,betak,ck} = hazbeta(data) 
 {ll, ll1, ll2} = hazregll(data, betahat)
 sigma = inv(ll2)                   ; covariance matix estimate    
 betahat
 sigma
 