; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         ls01
; ----------------------------------------------------------------------------
; Description   estimation of phonecal data set by OLS
; ----------------------------------------------------------------------------
  library("metrics")
;
  z = read("phonecal")
;
  x = matrix(rows(z))~z[,2]
  y = z[,3]
;
  b = gls(x,y)
;
; create graphical display and draw data points and regressions line
;
  d = createdisplay(1,1)
  data = x[,2]~y           ; data points
;
  yhat = x * b
  line = x[,2]~yhat      ; estimated regression line
  setmaskp(line, 0, 0, 0)
  setmaskl(line, (1:rows(line))', 4, 1, 3)
;
; display all objects
;
  show(d, 1, 1, data, line)
  setgopt(d, 1, 1, "title", "Least squares regression with outliers")
