; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         lts01
; ----------------------------------------------------------------------------
; Description   estimation of phonecal data set by OLS and LTS
;               with graphical output
; ----------------------------------------------------------------------------
  library("metrics")
;
  z = read("phonecal")
;
  x = matrix(rows(z))~z[,2]
  y = z[,3]
;
  bo = gls(x,y)
  b = lts(x,y)
;
; create graphical display and draw data points and regressions line
;
  d = createdisplay(1,1)
  data = x[,2]~y           ; data points
; OLS
  yhato = x * bo
  lineo = x[,2]~yhato    ; estimated regression line OLS
  setmaskp(lineo, 0, 0, 0)
  setmaskl(lineo, (1:rows(lineo))', 1, 1, 1)
; LTS  
  yhat = x * b
  line = x[,2]~yhat      ; estimated regression line LTS
  setmaskp(line, 0, 0, 0)
  setmaskl(line, (1:rows(line))', 4, 1, 3)
;
; display all objects
;
  show(d, 1, 1, data, lineo, line)
  setgopt(d, 1, 1, "title", "OLS and LTS regressions with outliers")