; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      seq
; ----------------------------------------------------------------------------
; Macro         seq01
; ----------------------------------------------------------------------------
; Description   Estimates the parameters of Klein's model
; ----------------------------------------------------------------------------
  library("metrics")
  ; reading in the data
  data=read("klein.dat")
  ; getting rid of the missing values of the lagged variables
  data=data[2:rows(data),]
  ; assigning the columns of "data" to the variables
  C=data[,2]
  P=data[,3]
  Wp=data[,4]
  I=data[,5]
  K1=data[,6]
  Y=data[,7]
  Wg=data[,8]
  G=data[,9]
  T=data[,10]
  W=data[,11]
  P1=data[,12]
  Y1=data[,13]
  A=data[,14]
  ; preparing the matrices that form seqlist1
  ; first matrix: concatenated vectors of left-hand side variables
  y=C~I~Wp
  ; a column of "1"s for constant term
  ONE=matrix(rows(data),1)
  ; second through (M+1)st matrix: matrices of right-hand side variables
  z1=P~P1~W~ONE
  z2=P~P1~K1~ONE
  z3=Y~Y1~A~ONE
  ; (M+2)nd matrix: matrix of instruments (exogenous and predetermined variables)
  x=ONE~G~T~Wg~A~P1~K1~Y1
  ; forming a list of matrices
  seqlist1=list(y,z1,z2,z3,x)
  ; now we will prepare the string vectors that will form seqlist2
  ; vector with names of left-hand side variables
  yl="C"|"I"|"Wp"
  ; vectors with names of right-hand side variables of equations 1 though M
  l1="P"|"P1"|"W"|"ONE"
  l2="P"|"P1"|"K1"|"ONE"
  l3="E"|"E1"|"A"|"ONE"
  ; vector with names of instruments
  xl="ONE"|"G"|"T"|"Wg"|"A"|"P1"|"K1"|"Y1"
  ; putting the string vectors into a list
  seqlist2=list(yl,l1,l2,l3,xl)
  ; finally, we call the seq-quantlet
  {d1,s,d2}=seq(seqlist1,seqlist2)
