proc()=xclusttest()
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    xclustmain
; -----------------------------------------------------------------------
; Macro       xclusttest
; -----------------------------------------------------------------------
; Description tests all macros of xclust
; -----------------------------------------------------------------------
; Usage       xclusttest()
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  randomize(0)
  x  = normal(200, 5)                                        
  x1 = x - #(2,1,3,0,0)'                                     
  x2 = x + #(1,1,3,1,0.5)'                                   
  x3 = x + #(0,0,1,5,1)'                                  
  x  = x1|x2|x3                                             
  w  = 1./var(x)                                            
  m  = matrix(rows(x))                                      
  t  = matrix(200)|matrix(200).+1|matrix(200).+2 
; adaptive
 {b, c, v, s, a} = adaptive(x, 3, w, m, t)                         
; adap
 {b, c, v, s, a} = adap(x, 3, w, m, t)                                   
; divisive
  randomize(0)
  x  = normal(30, 5)                                         
  x1 = x - #(2,1,3,0,0)'                                     
  x2 = x + #(1,1,3,1,0.5)'                                   
  x3 = x + #(0,0,1,5,1)'                                  
  x4 = x - #(0,2,1,3,0)'                                    
  x  = x1|x2|x3|x4                                          
  m  = matrix(rows(x))           
  w  = 1./var(x)                                            
  m  = matrix(rows(x))                                      
  {x, n, a} = divisive(x, 4, w, m, 1111)  
; kmcont
   x = #(4, 4, 25, 18, 10)~#(2, 3, 10, 24, 6)~#(3, 7, 12, 033, 7)~#(2, 4, 4, 13, 2)     
   t  = matrix(5)                                               
  {y, z, b, c, v, s, a} = kmcont(x, 2, t)  
; lpdist
  x = #(0, 0, 1, 1)~#(0, 1, 0, 1)                                   
  q = 1~1                        
  lpdist(x, q, 2)
; mat2vec
  d = #(0, 2, 3, 7)~#(2, 0, 1, 8)~#(3, 1, 0, 5)~#(7, 8, 5, 0)
  mat2vec(d)
; contmax
  h=#(20, 1, 3, 0, 4)~#(1, 7, 25, 6, 11)~#(3, 2, 1, 4, 5)~#(1, 6, 0, 0, 0)~#(0, 0, 1, 9, 1) 
  contmax(h)
; measure
  x = #(1, 1, 1, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3)
  y = #(2, 2, 2, 3, 1, 1, 3, 3, 3, 3, 3, 2, 2, 3, 2, 2, 1, 1, 1, 2, 1)         
  h = conting (x, y)    
  measure(h)
; pswap
  p = #(2, 1, 3, 4, 3, 2, 1, 4, 5, 4, 3, 2, 4, 1, 1, 2, 1, 4, 5)     
  c = #(2, 1, 3, 5)~#(1, 2, 5, 3)
  pswap(p, c)
; recode
  p = #(2, 1, 3, 4, 3, 2, 1, 4, 5, 4, 3, 2, 4, 1, 1, 2, 1, 4, 5) 
  c = #(2, 4, 5) 
  recode(c, p)
; vec2mat
  v = #(2, 3, 7, 1, 8, 5) 
  vec2mat(v)
; wardcont
  x = #(4, 4, 25, 18, 10)~#(2, 3, 10, 24, 6)~#(3, 7, 12, 33, 7)~#(2, 4, 4, 13, 2)
  {y, z, r, c} = wardcont(x, 3, 4)
endp