proc(yh)=xgobilowess(x,y,g,span)
; -----------------------------------------------------------------------
; Library      rpclib
; -----------------------------------------------------------------------
; See_also     xgobilocpol xgobinadawat xgobineunet
; -----------------------------------------------------------------------
; Macro        xgobilowess 
; -----------------------------------------------------------------------
; Description  conmputes a lowess fit for XGobi
; -----------------------------------------------------------------------
; Usage        yh = xgobilowess(x,y,g,span)
; Input
;   Parameter  x
;   Definition n x 1    matrix
;   Parameter  y
;   Definition n x 1    matrix
;   Parameter  g
;   Definition n x 1    matrix with integers starting at zero
;   Parameter  span
;   Definition scalar   span
; Output
;   Parameter  yh
;   Definition n x 1    matrix smoothed fit
; -----------------------------------------------------------------------
; Notes        XGobi gives span as negative number which allows the user
;	       to use the macro for other purposes. We expect that XGobi
;              sets span between -333 and -3900.
; -----------------------------------------------------------------------
; Example      ; load the library for XGobi
;	       library ("rpclib")
;              ; create a display
;	       d=createdisplay(1,1)
;	       ; read a data set
;  	       x=read("motcyc")
;              ; generate randomly three subgroups
;  	       g=floor(3.*uniform(rows(x)))
;              ; color the data after the subgroups
;              setmaskp (x, g, 3, 4)
;              ; show the data and the smooth
;              show (d, 1, 1, x, x[,1]~xgobilowess(x[,1],x[,2],g,0.4))
; -----------------------------------------------------------------------
; Result       shows a lowess fit of for the three 
;	       different subgroups in the data
; -----------------------------------------------------------------------
; Link         http://www.public.iastate.edu/~dicook/research/software.html XGobi
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960709
; -----------------------------------------------------------------------
  if (span<0)
    span = abs(span)/4000
    string ("span       : %.3f", span) 
  endif
  i  = 0
  mg = 1+max(g)
  yh = y
  k  = 1:rows(x)
  while (i<mg)
    xg = paf(x, g.=i)
    yg = paf(y, g.=i)
    kg = paf(k, g.=i)
    xg = sort(xg~yg~kg)
    yg = xg[,2]
    kg = xg[,3]
    xg = xg[,1]
    yh[kg] = lowess(xg, yg, span)
    i = i+1
  endo
endp
