; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph61
; -----------------------------------------------------------------
;   Description Coloring of data points 
;               by graphic commands.
; -----------------------------------------------------------------
  x  = 1:100                    ; creates variable x that takes 
                                ;    on the values 1, ..., 100
  y  = sin(x/20)+uniform(100)/5 ; creates y-variable as sin(x/20) 
                                ;    and uniform error
  data = x~y                    ; puts x, y together to form data
  ;
  ; now we call setmaskp to specify the layout for each point of 
  ; the matrix, all data points are colored red (=4), shown as 
  ; circles (=3) and have the default size (=8)
  ;
  setmaskp(data, 4, 3, 8)       ; calls setmaskp
  d = createdisplay(1, 1)       ; creates the display
  show(d, 1, 1, data)           ; use show puts data into display
