; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        kalm02
; -----------------------------------------------------------------
;   Description  Applies the Kalman filter on a time series.
; -----------------------------------------------------------------
;
  library("times")
  T = 100
  randomize(0)
  ex = normal(T)~(vec(1:T).*0)
  ey = normal(T).*2
  H = 1~0 
  F = #(0.5,1)~#(-0.3,0)
  x0 = #(0,0)
  ar2 = kemitor(T,x0,H,F,ey,ex)
;
  x0 = #(0,0)
  Sig = #(0,0)~#(0,0)
  H = 1~0
  F = #(0.5,1)~#(-0.3,0)
  Q = 4
  R = #(1,0)~#(0,0)
  filtered = kfilter(ar2,x0,Sig,H,F,Q,R)
; 
  library("plot")
  orig = vec(1:T)~ar2
  filt = vec(1:T)~filtered
  orig = setmask(orig, "line", "red", "thin")
  filt = setmask(filt, "line", "blue", "medium")
  disp = createdisplay(1,1)
  show(disp,1,1, orig, filt)
  setgopt(disp,1,1, "title", "AR(2) with noise - filtered")
