; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        nn1
; -----------------------------------------------------------------
;   Description  Simple classification network.
; -----------------------------------------------------------------
  setsize(640,480)
  library ("plot")
  library ("nn")
;
  randomize(0)
  n  = 200
  xt = normal(n,2)+#(-1,-1)' | normal(n,2)+#(+1,+1)'
;
  color  = string("red",1:n) | string("blue",1:n)
  symbol = string("circle",1:n) | string("triangle",1:n)
  xt     = setmask(xt, color, symbol)
  plot(xt)
  xl="x1"
  yl="x2"
  tl="Training Data Set"
  setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)
;
  yt = (matrix(n)-1)|matrix(n)
  w  = matrix(2*n)
  param = 1
  net = nnrnet(xt,yt,w,1)
;
  nnrinfo(net)
;
  x = normal(n,2)+#(-1,-1)' | normal(n,2)+#(+1,+1)'
  pred  = nnrpredict(x, net)
  prob  = pred.result
;
  y  = (matrix(n)-1)|matrix(n) ; true 
  yp = prob > 0.5              ; predicted
  misc = paf(1:2*n,y!=yp)      ; misclassified
  good = paf(1:2*n,y==yp)      ; correctly classified
  nm = rows(misc)
  sm = string("fill",1:nm)+symbol[misc]
  xm = setmask(x[misc],color[misc],sm,"huge")
  xg = setmask(x[good],color[good],symbol[good])
;
  pm = 100*nm/(2*n)            ; percentage of misclassified
  spm = string("%1.2f",pm)+"%"
  Network = createdisplay(1,1)
  show(Network,1,1,xg,xm)
  tl="Network: misclassified = "+spm
  setgopt(Network,1,1,"title",tl,"xlabel",xl,"ylabel",yl)
;
  mu0 = mean(xt[1:n])
  mu1 = mean(xt[n+1:2*n])
  mu  = (mu0+mu1)/2
  lin = inv(cov(xt))*(mu0-mu1)'
;
  y  = (matrix(n)-1)|matrix(n) ; true 
  yp = (x-mu)*lin<=0           ; predicted
  misc = paf(1:2*n,y!=yp)      ; misclassified
  good = paf(1:2*n,y==yp)      ; correctly classified
  nm = rows(misc)
  sm = string("fill",1:nm)+symbol[misc]
  xm = setmask(x[misc],color[misc],sm,"huge")
  xg = setmask(x[good],color[good],symbol[good])
  x  = setmask(x, color, symbol)
;
  pm = 100*nm/(2*n)            ; percentage of misclassified
  spm = string("%1.2f",pm)+"%"
  Discrim = createdisplay(1,1)
  show(Discrim,1,1,xg,xm)
  tl="Linear: misclassified = "+spm
  setgopt(Discrim,1,1,"title",tl,"xlabel",xl,"ylabel",yl)
;
  print(plotdisplay,"nndata1.ps")
  print(Network,"nnnet1.ps")
  print(Discrim,"nndis1.ps")
  


