; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        regr3
; -----------------------------------------------------------------
;   Description  Multiple linear regression and model selection.
; -----------------------------------------------------------------
  library("graphic")  ; reads the library graphic
  library("stats")    ; reads the library stats
;
  randomize(1)        ; sets a seed for the random generator
  eps=normal(10)      ; generates 10 standard normal errors
  x1=uniform(10)      ; generates 10 uniformly distributed values
  x2=uniform(10)
  x3=uniform(10)
  x4=uniform(10)
  x5=uniform(10)
  x=x1~x2~x3~x4~x5    ; creates the x data matrix
  y=2+2*x1-10*x3+0.5*x4+eps/10 ; creates y
  z=x~y               ; creates the data matrix z
  z                   ; outputs z
;
  {beta,bse,bstan,bpval}=linreg(x,y)  ; computes the linear
                                      ;    regression
;
  colname=string("X%.f",1:cols(x))  
                       ; sets the column names to X1,...,X5
;
  {beta,se,betastan,p} = linregbs(x,y,colname) 
                       ; computes the backward elimination
  {beta,se,betastan,p} = linregfs2(x,y,colname) 
                       ; computes the forward selection
  {beta,se,betastan,p} = linregstep(x,y,colname) 
                       ; computes the stepwise selection


