; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        smoo12
; -----------------------------------------------------------------
;   Description  Computes and plots a local linear regression 
;                together with a derivative estimate and the data.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  motcyc=read("motcyc")
  hh=lpregrot(motcyc)     ; rule-of-thumb bandwidth
  hd=lpderrot(motcyc)     ; rule-of-thumb bandwidth
  mh=lpregest(motcyc,hh)  ; local linear regression
  md=lpderest(motcyc,hd)  ; local quadratic derivative
  mh=setmask(mh,"line","black")
  md=setmask(md,"line","blue","dashed")
  xy=setmask(motcyc,"cross","small","red")
  plot(xy,mh,md)
  setgopt(plotdisplay,1,1,"title","Local Polynomial Estimation")




