; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        xtrm01
; -----------------------------------------------------------------
;   Description  Plots empirical qf and GP qf fitted by Moment(GP)
;                and Hill(GP1) to dyr.dat
; -----------------------------------------------------------------
;   Notes        Please use dyr1000.dat instead of dyr.dat, if you
;                have the XploRe Academic Edition.
; -----------------------------------------------------------------
library("finance")
library("xplore")
dyr=read("dyr.dat")
dyr=-dyr
;
m=momentgp(dyr,160)
;
setsize(640,480)
d=createdisplay(1,1)
;
t=aseq(0.965,350,0.0001)
qf=t~m.mu+m.sigma*qfx("gp",t,m.gamma)
qf=setmask(qf,"line","black","thin","dotted")
show(d,1,1,qf)
;
empqf=(4284:4444)/4445~sort(dyr)[4284:4444]
empqf=setmask(empqf,"line","black","thin","solid")
adddata(d,1,1,empqf)
;
h=hillgp1(dyr,160)
;
t=aseq(0.965,350,0.0001)
hqf=t~h.sigma*qfx("gp1",t,h.alpha)
hqf=setmask(hqf,"line","black","thin","dashed")
adddata(d,1,1,hqf)
;
setgopt(d,1,1,"xvalue",0|1,"yvalue",0|1,"ymajor",0.02)