#ifdef __cplusplus
  #define EXTERN extern "C"
#else
  #define EXTERN
#endif

/**** Compiler depended definitions ****/
/**** Definition of EXPORT */
/**** Definition of nan, inf and math constants */
/**** Definition of fixed byte datatypes */ 


/**** GNU C++  */

#ifdef __GNUC__
  
  #define EXPORT

  double dnan = 0.0/0.0, dinf = 1.0/0.0;

  #define INT1  signed char
  #define INT2  short
  #define INT4  int
  #define INT8  long
  #define DBL4  float
  #define DBL8  double

#endif

/**** Visual C++  */
#ifdef _MSC_VER
    
  #define EXPORT __declspec(dllexport)
   
  #include <ymath.h>
  double dnan = _Nan._D, dinf = _Inf._D;
  #define M_PI        3.14159265358979323846

  #define INT1  __int8
  #define INT2  __int16
  #define INT4  __int32
  #define INT8  __int64
  #define DBL4  float
  #define DBL8  double

#endif

/**** Borland C++  */
#ifdef __BORLANDC__
  
  #define EXPORT __export
 
  double dnan = 0.0/0.0, dinf = 1.0/0.0;

  #define INT1  __int8
  #define INT2  __int16
  #define INT4  __int32
  #define INT8  __int64
  #define DBL4  float
  #define DBL8  double

#endif

#ifdef __SC__
  
  #define EXPORT __export
  
  #include <fp.h>
  double dnan = NAN, dinf = INFINITY;

  #define INT1  char
  #define INT2  short
  #define INT4  long
  // #define INT8 	not supported by Symantec :(
  #define DBL4  float
  #define DBL8  double

#endif

/**** If none applies then set some defaults values */

#ifndef EXPORT
  
  #define EXPORT

  #define INT1  signed char
  #define INT2  short
  #define INT4  int
  #define INT8  long
  #define DBL4  float
  #define DBL8  double

#endif

typedef void* voidp;

