#include <stdio.h>

#ifdef __cplusplus
  #define EXTERN extern "C"
#else
  #define EXTERN
#endif

/**** Compiler depended definitions ****/
/**** Definition of EXPORT */
/**** Definition of nan, inf and math constants */
/**** Definition of fixed byte datatypes */ 


/**** GNU C++  */

#ifdef __GNUC__
  
  #define EXPORT

  double dnan = 0.0/0.0, dinf = 1.0/0.0;

  #define INT1  signed char
  #define INT2  short
  #define INT4  int
  #define INT8  long
  #define DBL4  float
  #define DBL8  double

#endif

/**** Visual C++  */
#ifdef _MSC_VER
    
  #define EXPORT __declspec(dllexport)
   
  #include <ymath.h>
  double dnan = _Nan._D, dinf = _Inf._D;
  #define M_PI        3.14159265358979323846

  #define INT1  __int8
  #define INT2  __int16
  #define INT4  __int32
  #define INT8  __int64
  #define DBL4  float
  #define DBL8  double

#endif

/**** Borland C++  */
#ifdef __BORLANDC__
  
  #define EXPORT __export
 
  double dnan = 0.0/0.0, dinf = 1.0/0.0;

  #define INT1  __int8
  #define INT2  __int16
  #define INT4  __int32
  #define INT8  __int64
  #define DBL4  float
  #define DBL8  double

#endif

#ifdef __SC__
  
  #define EXPORT __export
  
  #include <fp.h>
  double dnan = NAN, dinf = INFINITY;

  #define INT1  char
  #define INT2  short
  #define INT4  long
  // #define INT8 	not supported by Symantec :(
  #define DBL4  float
  #define DBL8  double

#endif

/**** If none applies then set some defaults values */

#ifndef EXPORT
  
  #define EXPORT

  #define INT1  signed char
  #define INT2  short
  #define INT4  int
  #define INT8  long
  #define DBL4  float
  #define DBL8  double

#endif

typedef void* voidp;

EXTERN int EXPORT sum (double *x, double *n, double *s)
{ long i, nn;

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%f\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);

}

EXTERN int EXPORT sumd8 (int argc, int *type, voidp *ptr)
{ long i, nn;
  DBL8 *x, *n, *s;

  x = (DBL8 *) ptr[0];
  n = (DBL8 *) ptr[1];
  s = (DBL8 *) ptr[2];

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%f\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);
}

EXTERN int EXPORT sumd4 (int argc, int *type, voidp *ptr)
{ long i, nn;
  DBL8 *n;
  DBL4 *x, *s;

  x = (DBL4 *) ptr[0];
  n = (DBL8 *) ptr[1];
  s = (DBL4 *) ptr[2];

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%f\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);
}

EXTERN int EXPORT sumi8 (int argc, int *type, voidp *ptr)
{ long i, nn;
  DBL8 *n;
  INT8 *x, *s;

  x = (INT8 *) ptr[0];
  n = (DBL8 *) ptr[1];
  s = (INT8 *) ptr[2];

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%f\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);
}

EXTERN int EXPORT sumi4 (int argc, int *type, voidp *ptr)
{ long i, nn;
  DBL8 *n;
  INT4 *x, *s;

  x = (INT4 *) ptr[0];
  n = (DBL8 *) ptr[1];
  s = (INT4 *) ptr[2];

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%i\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);
}

EXTERN int EXPORT sumi2 (int argc, int *type, voidp *ptr)
{ long i, nn;
  DBL8 *n;
  INT2 *x, *s;

  x = (INT2 *) ptr[0];
  n = (DBL8 *) ptr[1];
  s = (INT2 *) ptr[2];

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%i\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);
}

EXTERN int EXPORT sumi1 (int argc, int *type, voidp *ptr)
{ long i, nn;
  DBL8 *n;
  INT1 *x, *s;

  x = (INT1 *) ptr[0];
  n = (DBL8 *) ptr[1];
  s = (INT1 *) ptr[2];

  nn = (long) *n;
  *s = 0;
  for (i=0; i<nn; i++)
  { printf ("x[%li]=%i\n", i, *(x+i));
    *s += *(x+i);
  }

  return (0);
}

EXTERN int EXPORT sumc1 (int argc, int *type, voidp *ptr)
{ char *s;

  s = (char *) ptr[0];
  printf ("Text in DLL: %s\n", s);

  return (0);
}


