; -----------------------------------------------------------------
; Library        GRAPH
; -----------------------------------------------------------------
;   Macro        graph33
; -----------------------------------------------------------------
;   Description  Rescaled dotplot.
; -----------------------------------------------------------------
  library("plot")                ; loads library plot
  data = read ("bostonh")        ; reads Boston Housing data
  x = data[,14]                  ; selects 14th column  
  gr = grdot(x)                  ; generates dotplot
  scale = #(min(x),max(x))~#(-1, 2) ; generates scaling data set
  scale = setmask(scale,"white") ; makes scaling data "invisible"
  plot(gr, scale)                ; plots dotplot and scaling data
