; -----------------------------------------------------------------
; Library        GRAPH
; -----------------------------------------------------------------
;   Macro        graph62
; -----------------------------------------------------------------
;   Description Different coloring of data 
;               points by graphic commands.
; -----------------------------------------------------------------
  x  = 1:100                    ; creates variable x that takes 
                                ;    on the values 1, ..., 100
  y  = sin(x/20)+uniform(100)/5 ; creates y-variable as sin(x/20) 
                                ;    and uniform error
  data = x~y                    ; puts x, y together to form data
  ;
  ; now we will create a vector of integers that assigns the 
  ; color red (=4) to the first 50 data points and the color 
  ; magenta (=5) to the next 50 data points
  ;
  color = 4*matrix(50)|5*matrix(50)
  ;
  ; now we call setmaskp; as in the previous example, all points
  ; of data are shown as circles (=3) and have the default
  ; size (=8)
  ;  
  setmaskp(data, color, 3, 8)
  d = createdisplay(1, 1)       ; creates the display
  show(d, 1, 1, data)           ; use show puts data into display
