; -----------------------------------------------------------------
; Library        QUANT
; -----------------------------------------------------------------
;   Macro        quant17
; -----------------------------------------------------------------
;   Description  An interactive choice between linear and 
;                Nadaraya-Watson regression.
; -----------------------------------------------------------------
  proc()=regression(x,y)
    selhead  = "Choose regression method"
    selitem  = "Linear regression"|"Nadaraya-Watson"
    disp     = createdisplay(1,1)
    continue = 1
    show (disp, 1, 1, x~y)
    while (continue<>0)
      sel = selectitem (selhead, selitem)
      if (sel[1]==1)
        l = grlinreg(x~y)
        show (disp, 1, 1, x~y, l)
      endif
      if (sel[2]==1)
        h = (max(x)-min(x))/20
        w = sort(x~y)
        mh = regest(w)
        l = setmask(mh, "line")
        show (disp, 1, 1, x~y, l)
      endif
      continue = sum(sel)>0
    endo
  endp

  library("plot")
  library("smoother")
  x = read("bostonh")
  regression(x[,13], x[,14])
