; -----------------------------------------------------------------
; Library        SMOO
; -----------------------------------------------------------------
;   Macro        smoo04
; -----------------------------------------------------------------
;   Description  Family of kernel density estimates.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  netinc=read("nicfoo")
  netinc=netinc[,1]
;
  hfac=(max(netinc)-min(netinc))
  fh =setmask( denest(netinc,0.15*hfac) ,"line")
  fh1=setmask( denest(netinc,0.05*hfac) ,"line","thin","magenta")
  fh2=setmask( denest(netinc,0.10*hfac) ,"line","thin","red")
  fh3=setmask( denest(netinc,0.20*hfac) ,"line","thin","blue")
  fh4=setmask( denest(netinc,0.25*hfac) ,"line","thin","green")
  plot(fh1,fh2,fh3,fh4,fh)
  tl="Family of Density Estimates"
  xl="netincome"
  yl="density fh"
  setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)
