; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      eivvec1
; ----------------------------------------------------------------------------
; Macro         eiv06
; ----------------------------------------------------------------------------
; Description   estimates the vector of parameters of eiv model for simulated 
;               data using eivvec1
; ----------------------------------------------------------------------------
library("xplore")
library("eiv")
n = 100
randomize(n)
nu =#(2,3,4)
sig=0*matrix(3,3)
sig[,1]=#(0.25, 0.9, 0.1)
sig[,2]=#(0.9, 1, 0.2)
sig[,3]=#(0.1, 0.2, 4)
x=normal(n,3)*sig+nu'
w=x+0.01*normal(n,3)
a1=#(1.2, 1.3, 1.4)
y=0.75+x*a1+0.09*normal(n)
sigue=#(0.11, 0.09, 045)
siguu=0*matrix(3,3)
siguu[,1]=#(1.25, 0.009, 0.01)
siguu[,2]=#(0.009,0.081, 0.02)
siguu[,3]=#(0.01, 0.02, 1.96)
gest=eivvec1(w,y,sigue,siguu)
gest.mux
gest.hatbeta
gest.beta0
gest.hatsigmax
gest.hatsigmae
