; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      tp/cafpe/cafpe tp/cafpe/plotloclin
; ----------------------------------------------------------------------------
; Macro         flts09 
; ----------------------------------------------------------------------------
; Description   selects lags of nonlinear autoregressive process for lynx data
;               using CAFPE criterion
; ----------------------------------------------------------------------------
  pathcafpe 		= "tp/cafpe/" 	; path of CAFPE quantlets

; 	load required libraries
  library("xplore")
  library("times")
  func(pathcafpe + "cafpeload")		; load required XploRe files of CAFPE
  cafpeload(pathcafpe)    	

  setenv("outheadline","")     		; no header for each output file
  setenv("outlineno","")   		; no numbering of output lines
; 	set parameters
  truedat  		= "lynx.dat" 	; name of data file
  y			= 0
  xdataln  		= "yes";        ; take logarithms
  xdatadif  		= "no";     	; don't take first differences
  xdatastand		= "no";     	; don't standardize data
  lagmax   		= 6        	; the largest lag considered is 6
  searchmethod		= "full"    	; consider all possible lag combinations
  dmax     		= 6     	; consider at most 6 lags
; conduct lag selection
  { crmin,crpro } = cafpe(y,truedat,xdataln,xdatadif,xdatastand,lagmax,searchmethod,dmax)
  "selected lag vector,               estimated CAFPE "
  crmin[,1:dmax+1]
  "number of lags, chosen lag vector,        estimated CAFPE, plug-in bandwidth"
  (0:dmax)~crpro[,1:dmax|(dmax+4)|(dmax+1)]
