; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      tp/cafpe/plotloclin
; ----------------------------------------------------------------------------
; Macro         flts10
; ----------------------------------------------------------------------------
; Description   plots the nonparametric estimate of a
;               nonlinear regression function for the lynx data set          
; ----------------------------------------------------------------------------
  pathcafpe	= "tp/cafpe/"	; path of CAFPE quantlets

;	load required libraries
  library("xplore")
  library("times")
  func("jarber")
  func(pathcafpe + "cafpeload") ;load required XploRe files of CAFPE
  cafpeload(pathcafpe)    	

  setenv("outheadline","") 	; no header for each output file
  setenv("outlineno","")	; no numbering of output lines	
   
; 	set parameters
  lynx		= read("lynx.dat");		
  xresid	= 0
  xdataln 	= "yes"		; take logarithms
  xdatadif 	= "no"		; don't take first differences
  xdatastand	= "no"		; don't standardize data
  lags      	= 1|2          	; lag vector for regression function
  volat 	= "no"		
  h		= 0
  xsconst   	= 1e-100|1e-100	; 1e-100 for the lags which are varied
                                ; for those kept fixed it includes the
                                ; chosen constant
  gridnum   	= 30           	; number of gridpoints in one direction
  gridmax     	= 9             ; maximum of grid
  gridmin     	= 4             ; minimum of grid
; compute optimal bandwidth and plot regression function for given lags
  { hplugin,hB,hC,xs,resid } = plotloclin(lynx,xresid,xdataln,xdatadif,xdatastand,volat,lags,h,xsconst,gridnum,gridmax,gridmin)
  "plug-in bandwidth" hplugin

; 	diagnostics
   acfplot(resid)		; compute and plot autocorrelation function of residuals
  {jb,probjb,sk,k} = jarber(resid,1)
				; compute Jarque-Bera test for normality of residuals
; rotate view
  m=#(0.38269, 0.18024, -0.90612)
  m=m~#(-0.92387, 0.074675, -0.37534)
  m=m~#(1.5084e-05, 0.98078, 0.19509)
  setgopt(d1, 1, 1, "rotcos", m')
; note displays are global objects
