; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      uniform
; ----------------------------------------------------------------------------
; Macro         haz00
; ----------------------------------------------------------------------------
; Description   generates the pseudo-random data set haz01.dat
; ----------------------------------------------------------------------------
 n = 20                             ; sample size
 p = 2                              ; number of covariates
 beta = 1|2                         ; regression parameter
 z = uniform(n,p) - 0.5             ; randomly generated covariates
 y = -log(1-uniform(n))             ; exponential event times
 y = y./exp(z*beta)                 ; covariate effects included
 c = 4*uniform(n)                   ; censoring times
 t = min(y~c,2)                     ; observed times             
 delta = (y<=c)                     ; censoring indicator

 write(t~delta~z,"haz01.dat")       ; saving the data haz01.dat  
    