; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         lts04
; ----------------------------------------------------------------------------
; Description   estimation of stacklos data set by LTS
;               with a residual plot
; ----------------------------------------------------------------------------
  library("metrics")
  library("graphic")
;
  z = read("stacklos")
;
  n = rows(z)
  h = 12
  x = matrix(n)~z[,2:4]
  y = z[,5]
;
  b = lts(x,y,h,1)
;
; residuals
;
  d = createdisplay(1,1)    
  yhat = x * b
  res = y - yhat
  sigma = 1.483*median(abs(res - median(res)))
  p = (1:n)~res
  l0 = gryline(0, #(0,n)) 
  l1 = gryline(sigma, #(0,n))
  l2 = gryline(-sigma, #(0,n))
  setmaskl(l1, (1:rows(l1))', 1, 1, 1) 
  setmaskl(l2, (1:rows(l2))', 1, 1, 1)
  l3 = gryline(3*sigma, #(0,n))
  l4 = gryline(-3*sigma, #(0,n))
  setmaskl(l3, (1:rows(l3))', 1, 1, 3)
  setmaskl(l4, (1:rows(l4))', 1, 1, 3)
  show (d, 1, 1, p, l0, l1, l2, l3, l4)
  title="LTS residual plot - stackloss data"
  setgopt(d, 1, 1,"title",title) 
