; -----------------------------------------------------------------
; Library        MATRIX
; -----------------------------------------------------------------
;   Macro        matrix04
; -----------------------------------------------------------------
;   Description  Extracting elements of a matrix.
; -----------------------------------------------------------------
;
  mat=(1|2|3|4)~(5|6|7|8)~(9|9|9|9)
;
  mat[1,]                  ; extract first row
  mat[,2]                  ; extract second column
  mat[4,3]                 ; extract element (4,3)
;
  mat[1:3,1|3]             ; extract first rows 1 to 3
                           ;    and columns 1 and 3
;
  x = #(1,3,5)~#(2,4,6)
  index (x,#(3,2))         ; extract rows 3 and 2
;
  x = #(4, 2, 5)
  ind = x > 3              ; indices of rows with elements > 3
  paf(x, ind)              ; select those form x
;
  x = #(4,2,5)~#(1,7,4)
  x
  sort(x,-2)               ; sort x w.r.t. 2nd column, in 
                           ;    descending order
;
  sort(x,0)                ; sort columns independently
