; -----------------------------------------------------------------
; Library        MATRIX
; -----------------------------------------------------------------
;   Macro        matrix08
; -----------------------------------------------------------------
;   Description  Matrix decompositions.
; -----------------------------------------------------------------
;
  x = #(1, 2)~#(2, 3)
  y = eigsm(x)         ; spectral decomposition
  y
;
  det(x) - y.values[1] * y.values[2]
;
  y.vectors'*y.vectors
;
  z = y.vectors *diag(y.values) *y.vectors'
  z
;
  xinv = y.vectors*inv(diag(y.values))*y.vectors' 
  xinv
  inv(x)
;
  x = #(1, 2, 3)~#(2, 3, 4)
  y = svd(x)       ; singular value decomposition
  y
;
  xx = y.u *diag(y.l) *y.v'
  xx
;
  x = #(1, 2)~#(2, 3)
  lu = ludecomp(x) ; LU decomposition
  lu
;
  index(lu.l*lu.u,lu.index)
;
  library("xplore")          ; unit is in library xplore!
  x = #(2,2)~#(2,3)
  tmp = chold(x, rows(x))
  d = diag(xdiag(tmp))       ; diagonal matrix
  b = tmp-d+unit(rows(tmp))  ; lower triangular
  L = b'*sqrt(d)             ; Cholesky triangular
;
  x - L*L'
