proc(FARcov)=FARcov(n,d)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    FARgk, FARx, genarma
; ---------------------------------------------------------------------
; Macro       FARcov
; ---------------------------------------------------------------------
; Description Procedure for the calculation of the covariance function
;							of a fractional ARIMA(0,d,0) model, uses the Fast Fourier
;							Transform
; ---------------------------------------------------------------------
; Usage       (FARcov)=FARcov(n,H)
; Input       
; Parameter   n	length of the generated series
; Definition  
; Parameter   d self similarity parameter d=H-1/2, must be between 0 
; Definition    and 0.5
; Output      
; Parameter   FARcov vector of the covariances
; Definition  
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     cov=FARcov(4,.3)
; ---------------------------------------------------------------------
; Result      Contents of cov
;							[1,]   1.3165
;							[2,]  0.56422
;             [3,]  0.43146
;             [4,]  0.36754
; ---------------------------------------------------------------------
; Keywords    fractional ARIMA, self similarity, long memory
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistics for Long Memory Processes", Chapman
;							& Hall 1994
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
cov=matrix(n)
k=0
while (k<n)
	cov[k+1]=exp(lgamma(1-2*d)+lgamma(k+d)-lgamma(k-d+1)-lgamma(d)-lgamma(1-d))
	k=k+1
endo
FARcov=cov
endp