proc(FARx)=FARx(m,d)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also   	FARcov, FARgk, genarma, FBMx 
; ---------------------------------------------------------------------
; Macro       FARx
; ---------------------------------------------------------------------
; Description Simulation of a series of fractional ARIMA(0,d,0) by a 
;							method proposed by Davies and Harte
; ---------------------------------------------------------------------
; Usage       (FARx)=FARx(m,d)
; Input       
; Parameter   m length of the series to be simulated, must be a power
; Definition  	of 2 due to the Fast Fourier Transform
; Parameter   d self similarity parameter, d=H-1/2
; Definition  
; Output      
; Parameter   FARx generated series
; Definition  
; ---------------------------------------------------------------------
; Notes       needs FARcov and FARgk
; ---------------------------------------------------------------------
; Example     x=FARx(4,.3)
; ---------------------------------------------------------------------
; Result      Contents of x
;							[1,]  -0.38327
;							[2,]  -0.55771
;							[3,]   0.28111
;							[4,]   0.16572
;----------------------------------------------------------------------
; Keywords    fractional ARIMA, self similarity, simulation
; ---------------------------------------------------------------------
; Reference   Beran, J "Statistics for Long Memory Processes", Chapman
;							& Hall 1994
;							Davies, R.B. and Harte, D.S. "Test for Hurst effect"
;							Biometrica 74, 1987
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
n=m+1
z=normal(2*n)
i=0
z[1]=z[1]*sqrt(2)
z[n]=z[n]*sqrt(2)
z[n+1]=0
z[2*n]=0
k=0
zk=matrix(2*n-2)
while (k<2*n-2)
	k=k+1
	if (k<=n)
		zk[k]=z[k]
	else
		zk[k]=z[2*n-k]
	endif
endo
faktor=1/(2*sqrt(n-1))
gk=FARgk(m,d)
sqrtgk=sqrt(gk)
zsgk=matrix(2*n-2)
k=0
while (k<2*n-2)
	k=k+1
	zsgk[k]=zk[k]*sqrtgk[k]
endo
hilfsmatrix=matrix(2*n-2)-matrix(2*n-2)
zsgk=zsgk~hilfsmatrix
xt=faktor*fft(zsgk)
xt=xt[1:m]
FARx=xt[,1]
endp
		