proc(FBMx)=FBMx(n,H,startval)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also 		FGNx,FGNgk,FGNcov,fracbrown,hurst  
; ---------------------------------------------------------------------
; Macro       FBMx
; ---------------------------------------------------------------------
; Description Calculation of a series of fractional Brownian motion,
;							after a method proposed by Davies and Harte
; ---------------------------------------------------------------------
; Usage       (FBMx)=FBMx(n,H)
; Input       
; Parameter   n	length of the generated series, must be power of 2
; Definition  
; Parameter   H Hurst Koeffizient as self similarity parameter
; Definition  
; Parameter
;	Definition	startval Starting Value of the series
; Output      
; Parameter   FBMx vector of the generated series
; Definition  
; ---------------------------------------------------------------------
; Notes       needs FARcov, FARgk and FARx
; ---------------------------------------------------------------------
; Example     x=FBMx(4,.7,0)
; ---------------------------------------------------------------------
; Result      Contents of x
;							[1,]      0
;							[2,]  1.407
;							[3,] 2.2431
;							[4,] 1.5175
; ---------------------------------------------------------------------
; Keywords    fractional Brownian Motion, self similarity
; ---------------------------------------------------------------------
; Reference   Davies, R.B. and Harte, D.S. "Test for Hurst effect",
;							Biometrica 74, 1987
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wnsche, 000402
; ---------------------------------------------------------------------
//
x=FGNx(n,H)
xt=matrix(n)
xt[1]=startval
t=0
while (t<n-1)
	t=t+1
	xt[t+1]=xt[t]+x[t]
endo
FBMx=xt
endp