proc(gk)=FGNgk(m,H)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    FGNcov,FGNx,FBMx,fft
; ---------------------------------------------------------------------
; Macro       FGNgk
; ---------------------------------------------------------------------
; Description Calculation of a series gk for the calculation of
;							fractional Gaussian noise by a method proposed by Davies
;							and Harte
; ---------------------------------------------------------------------
; Usage       (gk)=FGNgk(m,H)
; Input       
; Parameter   m	Length of the series of fractional Gaussian noise
; Definition  	generated by procedure FGNx, must be a power of 2
; Parameter   H	Hurst Koeffizient as self similarity parameter
; Definition  
; Output      
; Parameter   gk vector of term used by FGNx
; Definition  
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     gk=FGNgk(2,.7)
; ---------------------------------------------------------------------
; Result      Contents of gk
;							[1,]  1.8278
;							[2,] 0.81125
;							[3,] 0,54974
;							[4,] 0,81125
; ---------------------------------------------------------------------
; Keywords    fractional Gaussian Noise, fractional Brownian Motion,
;							self similarity
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistic for Long Memory Processes", Chapman
;							& Hall 1994
;							Davies, R.B. and Harte, D.S. "Test for Hurst effect"
;							Biometrica 74, 1987
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wnsche 000402
; ---------------------------------------------------------------------
//
n=m+1
gammak=FGNcov(n,H)
i=0
cvre=matrix(2*(n-1))
cvim=matrix(2*(n-1))-matrix(2*(n-1))
while  (i<n-1)
  i=i+1
  cvre[i]=gammak[i]
  cvre[2*(n-1)-i+1]=gammak[i+1]
endo
cv=matrix(2*(n-1),2)
cv=cvre~cvim
gk=fft(cv)[,1]
endp